using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgRecentOrders
	/// </summary>
	public class DlgRecentOrders : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;
		private DataTable _componentOrders;
		private DataTable _units;
		private DataTable _diagnosticTests;
		private DataTable _testResults;
		//
		private gov.va.med.vbecs.GUI.controls.PatientDisplayPanel patientDisplayPanel2;
		private System.Windows.Forms.Panel pnlSelectedOrder;
		private System.Windows.Forms.Panel pnlRight;
		private System.Windows.Forms.Panel pnlBotRight;
		private System.Windows.Forms.Panel pnlComponents;
		private System.Windows.Forms.Label lblComponents;
		private System.Windows.Forms.ListView lvComponents;
		private System.Windows.Forms.Panel pnlDiagnosticTest;
		private System.Windows.Forms.Label lblDiagnosticTest;
		private System.Windows.Forms.ListView lvDiagnosticTest;
		private System.Windows.Forms.Panel pnlOrder;
		private System.Windows.Forms.TextBox txtDivision;
		private System.Windows.Forms.Label lblDivision;
		private System.Windows.Forms.TextBox txtOrderStatus;
		private System.Windows.Forms.Label lblOrderStatus;
		private System.Windows.Forms.TextBox txtDateReceived;
		private System.Windows.Forms.Label lblDateReceived;
		private System.Windows.Forms.TextBox txtSpecimenUID;
		private System.Windows.Forms.Label lblSpecimenUID;
		private System.Windows.Forms.Label lblOrderDetails;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlTree;
		private System.Windows.Forms.TreeView tvOrders;
		private System.Windows.Forms.Label lblOrders;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.ColumnHeader columnHeader19;
		private System.Windows.Forms.ColumnHeader columnHeader20;
		private System.Windows.Forms.ColumnHeader columnHeader21;
		private System.Windows.Forms.ColumnHeader columnHeader22;
		private System.Windows.Forms.ColumnHeader columnHeader23;
		private System.Windows.Forms.ColumnHeader columnHeader24;
		private System.Windows.Forms.ColumnHeader columnHeader25;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.GroupBox grpOrders;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Panel pnlPatientSelect;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.Panel pnlRecentOrders;
		private System.Windows.Forms.Panel pnlLevel1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgRecentOrders()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgRecentOrders(BOL.Patient patient) : this()
		{
			using ( new WaitCursor())
			{
				this.Patient = patient;
				//
				GetRecentOrders();
				//
				this.pnlPatientSelect.Visible = false;
				this.pnlRecentOrders.Visible = true;
				//
				this.LoadRecentOrders();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgRecentOrders));
			this.patientDisplayPanel2 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
			this.grpOrders = new System.Windows.Forms.GroupBox();
			this.pnlSelectedOrder = new System.Windows.Forms.Panel();
			this.pnlRight = new System.Windows.Forms.Panel();
			this.pnlBotRight = new System.Windows.Forms.Panel();
			this.pnlDiagnosticTest = new System.Windows.Forms.Panel();
			this.lvDiagnosticTest = new System.Windows.Forms.ListView();
			this.columnHeader23 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader24 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader25 = new System.Windows.Forms.ColumnHeader();
			this.lblDiagnosticTest = new System.Windows.Forms.Label();
			this.pnlComponents = new System.Windows.Forms.Panel();
			this.lblComponents = new System.Windows.Forms.Label();
			this.lvComponents = new System.Windows.Forms.ListView();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader16 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader19 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader20 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader21 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader22 = new System.Windows.Forms.ColumnHeader();
			this.pnlOrder = new System.Windows.Forms.Panel();
			this.txtDivision = new System.Windows.Forms.TextBox();
			this.lblDivision = new System.Windows.Forms.Label();
			this.txtDateReceived = new System.Windows.Forms.TextBox();
			this.lblDateReceived = new System.Windows.Forms.Label();
			this.lblOrderDetails = new System.Windows.Forms.Label();
			this.pnlLevel1 = new System.Windows.Forms.Panel();
			this.txtOrderStatus = new System.Windows.Forms.TextBox();
			this.lblOrderStatus = new System.Windows.Forms.Label();
			this.txtSpecimenUID = new System.Windows.Forms.TextBox();
			this.lblSpecimenUID = new System.Windows.Forms.Label();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlTree = new System.Windows.Forms.Panel();
			this.tvOrders = new System.Windows.Forms.TreeView();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.lblOrders = new System.Windows.Forms.Label();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.btnClose = new System.Windows.Forms.Button();
			this.pnlRecentOrders = new System.Windows.Forms.Panel();
			this.pnlPatientSelect = new System.Windows.Forms.Panel();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpOrders.SuspendLayout();
			this.pnlSelectedOrder.SuspendLayout();
			this.pnlRight.SuspendLayout();
			this.pnlBotRight.SuspendLayout();
			this.pnlDiagnosticTest.SuspendLayout();
			this.pnlComponents.SuspendLayout();
			this.pnlOrder.SuspendLayout();
			this.pnlLevel1.SuspendLayout();
			this.pnlTree.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.pnlRecentOrders.SuspendLayout();
			this.pnlPatientSelect.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.Title = "Recent Orders";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// patientDisplayPanel2
			// 
			this.patientDisplayPanel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientDisplayPanel2.EnabledBloodAvailButton = false;
			this.patientDisplayPanel2.EnabledMedicationButton = false;
			this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
			this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
			this.patientDisplayPanel2.EnabledSIAndTRButton = false;
			this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
			this.patientDisplayPanel2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientDisplayPanel2.Location = new System.Drawing.Point(4, 0);
			this.patientDisplayPanel2.Name = "patientDisplayPanel2";
			this.patientDisplayPanel2.Patient = null;
			this.patientDisplayPanel2.Size = new System.Drawing.Size(686, 44);
			this.patientDisplayPanel2.TabIndex = 0;
			// 
			// grpOrders
			// 
			this.grpOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpOrders.Controls.Add(this.pnlSelectedOrder);
			this.grpOrders.Location = new System.Drawing.Point(48, 44);
			this.grpOrders.Name = "grpOrders";
			this.grpOrders.Size = new System.Drawing.Size(640, 368);
			this.grpOrders.TabIndex = 67;
			this.grpOrders.TabStop = false;
			this.grpOrders.Text = "Recent Diagnostic Test and Component Orders";
			// 
			// pnlSelectedOrder
			// 
			this.pnlSelectedOrder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSelectedOrder.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlSelectedOrder.Controls.Add(this.pnlRight);
			this.pnlSelectedOrder.Controls.Add(this.splitter1);
			this.pnlSelectedOrder.Controls.Add(this.pnlTree);
			this.pnlSelectedOrder.Location = new System.Drawing.Point(8, 16);
			this.pnlSelectedOrder.Name = "pnlSelectedOrder";
			this.pnlSelectedOrder.Size = new System.Drawing.Size(624, 344);
			this.pnlSelectedOrder.TabIndex = 3;
			// 
			// pnlRight
			// 
			this.pnlRight.Controls.Add(this.pnlBotRight);
			this.pnlRight.Controls.Add(this.pnlOrder);
			this.pnlRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlRight.Location = new System.Drawing.Point(143, 0);
			this.pnlRight.Name = "pnlRight";
			this.pnlRight.Size = new System.Drawing.Size(479, 342);
			this.pnlRight.TabIndex = 2;
			// 
			// pnlBotRight
			// 
			this.pnlBotRight.Controls.Add(this.pnlDiagnosticTest);
			this.pnlBotRight.Controls.Add(this.pnlComponents);
			this.pnlBotRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlBotRight.Location = new System.Drawing.Point(0, 128);
			this.pnlBotRight.Name = "pnlBotRight";
			this.pnlBotRight.Size = new System.Drawing.Size(479, 214);
			this.pnlBotRight.TabIndex = 5;
			// 
			// pnlDiagnosticTest
			// 
			this.pnlDiagnosticTest.Controls.Add(this.lvDiagnosticTest);
			this.pnlDiagnosticTest.Controls.Add(this.lblDiagnosticTest);
			this.pnlDiagnosticTest.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlDiagnosticTest.Location = new System.Drawing.Point(0, 0);
			this.pnlDiagnosticTest.Name = "pnlDiagnosticTest";
			this.pnlDiagnosticTest.Size = new System.Drawing.Size(479, 214);
			this.pnlDiagnosticTest.TabIndex = 2;
			this.pnlDiagnosticTest.Visible = false;
			// 
			// lvDiagnosticTest
			// 
			this.lvDiagnosticTest.AccessibleDescription = "Diagnostic Tests";
			this.lvDiagnosticTest.AccessibleName = "Diagnostic Tests";
			this.lvDiagnosticTest.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvDiagnosticTest.BackColor = System.Drawing.SystemColors.Control;
			this.lvDiagnosticTest.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnHeader23,
																							   this.columnHeader24,
																							   this.columnHeader25});
			this.lvDiagnosticTest.FullRowSelect = true;
			this.lvDiagnosticTest.Location = new System.Drawing.Point(4, 24);
			this.lvDiagnosticTest.MultiSelect = false;
			this.lvDiagnosticTest.Name = "lvDiagnosticTest";
			this.lvDiagnosticTest.Size = new System.Drawing.Size(468, 184);
			this.lvDiagnosticTest.TabIndex = 6;
			this.lvDiagnosticTest.View = System.Windows.Forms.View.Details;
			this.lvDiagnosticTest.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvDiagnosticTest_ColumnClick);
			// 
			// columnHeader23
			// 
			this.columnHeader23.Text = "Diagnostic Test";
			this.columnHeader23.Width = 120;
			// 
			// columnHeader24
			// 
			this.columnHeader24.Text = "Interpretation";
			this.columnHeader24.Width = 120;
			// 
			// columnHeader25
			// 
			this.columnHeader25.Text = "Comments";
			this.columnHeader25.Width = 200;
			// 
			// lblDiagnosticTest
			// 
			this.lblDiagnosticTest.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.lblDiagnosticTest.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblDiagnosticTest.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblDiagnosticTest.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblDiagnosticTest.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblDiagnosticTest.Location = new System.Drawing.Point(0, 0);
			this.lblDiagnosticTest.Name = "lblDiagnosticTest";
			this.lblDiagnosticTest.Size = new System.Drawing.Size(479, 20);
			this.lblDiagnosticTest.TabIndex = 4;
			this.lblDiagnosticTest.Text = "Diagnostic Test";
			this.lblDiagnosticTest.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlComponents
			// 
			this.pnlComponents.Controls.Add(this.lblComponents);
			this.pnlComponents.Controls.Add(this.lvComponents);
			this.pnlComponents.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlComponents.Location = new System.Drawing.Point(0, 0);
			this.pnlComponents.Name = "pnlComponents";
			this.pnlComponents.Size = new System.Drawing.Size(479, 214);
			this.pnlComponents.TabIndex = 3;
			this.pnlComponents.Visible = false;
			// 
			// lblComponents
			// 
			this.lblComponents.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.lblComponents.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblComponents.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblComponents.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblComponents.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblComponents.Location = new System.Drawing.Point(0, 0);
			this.lblComponents.Name = "lblComponents";
			this.lblComponents.Size = new System.Drawing.Size(479, 20);
			this.lblComponents.TabIndex = 4;
			this.lblComponents.Text = "Components";
			this.lblComponents.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvComponents
			// 
			this.lvComponents.AccessibleDescription = "Component Tests";
			this.lvComponents.AccessibleName = "Component Tests";
			this.lvComponents.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvComponents.BackColor = System.Drawing.SystemColors.Control;
			this.lvComponents.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.columnHeader13,
																						   this.columnHeader16,
																						   this.columnHeader14,
																						   this.columnHeader19,
																						   this.columnHeader20,
																						   this.columnHeader21,
																						   this.columnHeader22});
			this.lvComponents.FullRowSelect = true;
			this.lvComponents.Location = new System.Drawing.Point(4, 24);
			this.lvComponents.MultiSelect = false;
			this.lvComponents.Name = "lvComponents";
			this.lvComponents.Size = new System.Drawing.Size(468, 184);
			this.lvComponents.TabIndex = 6;
			this.lvComponents.View = System.Windows.Forms.View.Details;
			this.lvComponents.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvComponents_ColumnClick);
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "Unit ID";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader16
			// 
			this.columnHeader16.Text = "Product";
			this.columnHeader16.Width = 80;
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "ABO/Rh";
			// 
			// columnHeader19
			// 
			this.columnHeader19.Text = "Expires";
			this.columnHeader19.Width = 80;
			// 
			// columnHeader20
			// 
			this.columnHeader20.Text = "Donation Type";
			this.columnHeader20.Width = 65;
			// 
			// columnHeader21
			// 
			this.columnHeader21.Text = "Status";
			this.columnHeader21.Width = 80;
			// 
			// columnHeader22
			// 
			this.columnHeader22.Text = "Issue-To Location";
			// 
			// pnlOrder
			// 
			this.pnlOrder.Controls.Add(this.txtDivision);
			this.pnlOrder.Controls.Add(this.lblDivision);
			this.pnlOrder.Controls.Add(this.txtDateReceived);
			this.pnlOrder.Controls.Add(this.lblDateReceived);
			this.pnlOrder.Controls.Add(this.lblOrderDetails);
			this.pnlOrder.Controls.Add(this.pnlLevel1);
			this.pnlOrder.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlOrder.Location = new System.Drawing.Point(0, 0);
			this.pnlOrder.Name = "pnlOrder";
			this.pnlOrder.Size = new System.Drawing.Size(479, 128);
			this.pnlOrder.TabIndex = 4;
			// 
			// txtDivision
			// 
			this.txtDivision.AccessibleDescription = "Division";
			this.txtDivision.AccessibleName = "Division";
			this.txtDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDivision.Location = new System.Drawing.Point(92, 28);
			this.txtDivision.Name = "txtDivision";
			this.txtDivision.ReadOnly = true;
			this.txtDivision.Size = new System.Drawing.Size(376, 20);
			this.txtDivision.TabIndex = 2;
			this.txtDivision.Text = "";
			// 
			// lblDivision
			// 
			this.lblDivision.Location = new System.Drawing.Point(12, 28);
			this.lblDivision.Name = "lblDivision";
			this.lblDivision.Size = new System.Drawing.Size(100, 20);
			this.lblDivision.TabIndex = 11;
			this.lblDivision.Text = "Division";
			this.lblDivision.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateReceived
			// 
			this.txtDateReceived.AccessibleDescription = "Date Received";
			this.txtDateReceived.AccessibleName = "Date Received";
			this.txtDateReceived.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateReceived.Location = new System.Drawing.Point(92, 52);
			this.txtDateReceived.Name = "txtDateReceived";
			this.txtDateReceived.ReadOnly = true;
			this.txtDateReceived.Size = new System.Drawing.Size(376, 20);
			this.txtDateReceived.TabIndex = 3;
			this.txtDateReceived.Text = "";
			// 
			// lblDateReceived
			// 
			this.lblDateReceived.Location = new System.Drawing.Point(12, 52);
			this.lblDateReceived.Name = "lblDateReceived";
			this.lblDateReceived.Size = new System.Drawing.Size(100, 20);
			this.lblDateReceived.TabIndex = 7;
			this.lblDateReceived.Text = "Date Received";
			this.lblDateReceived.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOrderDetails
			// 
			this.lblOrderDetails.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.lblOrderDetails.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblOrderDetails.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblOrderDetails.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblOrderDetails.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblOrderDetails.Location = new System.Drawing.Point(0, 0);
			this.lblOrderDetails.Name = "lblOrderDetails";
			this.lblOrderDetails.Size = new System.Drawing.Size(479, 20);
			this.lblOrderDetails.TabIndex = 4;
			this.lblOrderDetails.Text = "Order Details";
			this.lblOrderDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlLevel1
			// 
			this.pnlLevel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlLevel1.Controls.Add(this.txtOrderStatus);
			this.pnlLevel1.Controls.Add(this.lblOrderStatus);
			this.pnlLevel1.Controls.Add(this.txtSpecimenUID);
			this.pnlLevel1.Controls.Add(this.lblSpecimenUID);
			this.pnlLevel1.Location = new System.Drawing.Point(8, 72);
			this.pnlLevel1.Name = "pnlLevel1";
			this.pnlLevel1.Size = new System.Drawing.Size(464, 52);
			this.pnlLevel1.TabIndex = 13;
			this.pnlLevel1.Visible = false;
			// 
			// txtOrderStatus
			// 
			this.txtOrderStatus.AccessibleDescription = "Order Status";
			this.txtOrderStatus.AccessibleName = "Order Status";
			this.txtOrderStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderStatus.Location = new System.Drawing.Point(84, 4);
			this.txtOrderStatus.Name = "txtOrderStatus";
			this.txtOrderStatus.ReadOnly = true;
			this.txtOrderStatus.Size = new System.Drawing.Size(376, 20);
			this.txtOrderStatus.TabIndex = 4;
			this.txtOrderStatus.Text = "";
			// 
			// lblOrderStatus
			// 
			this.lblOrderStatus.Location = new System.Drawing.Point(4, 4);
			this.lblOrderStatus.Name = "lblOrderStatus";
			this.lblOrderStatus.Size = new System.Drawing.Size(100, 20);
			this.lblOrderStatus.TabIndex = 9;
			this.lblOrderStatus.Text = "Order Status";
			this.lblOrderStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpecimenUID
			// 
			this.txtSpecimenUID.AccessibleDescription = "Specimen U I D";
			this.txtSpecimenUID.AccessibleName = "Specimen U I D";
			this.txtSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenUID.Location = new System.Drawing.Point(84, 28);
			this.txtSpecimenUID.Name = "txtSpecimenUID";
			this.txtSpecimenUID.ReadOnly = true;
			this.txtSpecimenUID.Size = new System.Drawing.Size(376, 20);
			this.txtSpecimenUID.TabIndex = 5;
			this.txtSpecimenUID.Text = "";
			// 
			// lblSpecimenUID
			// 
			this.lblSpecimenUID.Location = new System.Drawing.Point(4, 28);
			this.lblSpecimenUID.Name = "lblSpecimenUID";
			this.lblSpecimenUID.Size = new System.Drawing.Size(100, 20);
			this.lblSpecimenUID.TabIndex = 5;
			this.lblSpecimenUID.Text = "Specimen UID";
			this.lblSpecimenUID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(140, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 342);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlTree
			// 
			this.pnlTree.Controls.Add(this.tvOrders);
			this.pnlTree.Controls.Add(this.lblOrders);
			this.pnlTree.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTree.Location = new System.Drawing.Point(0, 0);
			this.pnlTree.Name = "pnlTree";
			this.pnlTree.Size = new System.Drawing.Size(140, 342);
			this.pnlTree.TabIndex = 0;
			// 
			// tvOrders
			// 
			this.tvOrders.AccessibleDescription = "Orders";
			this.tvOrders.AccessibleName = "Orders";
			this.tvOrders.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.tvOrders.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tvOrders.HideSelection = false;
			this.tvOrders.ImageList = this.imageList1;
			this.tvOrders.Location = new System.Drawing.Point(0, 20);
			this.tvOrders.Name = "tvOrders";
			this.tvOrders.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {
																				 new System.Windows.Forms.TreeNode("07/03/2003", 1, 1, new System.Windows.Forms.TreeNode[] {
																																											   new System.Windows.Forms.TreeNode("TAS", 2, 2),
																																											   new System.Windows.Forms.TreeNode("RBC x4")}),
																				 new System.Windows.Forms.TreeNode("07/04/2003", 1, 1, new System.Windows.Forms.TreeNode[] {
																																											   new System.Windows.Forms.TreeNode("XM", 2, 2),
																																											   new System.Windows.Forms.TreeNode("CRYO X3")}),
																				 new System.Windows.Forms.TreeNode("07/05/2003", 1, 1, new System.Windows.Forms.TreeNode[] {
																																											   new System.Windows.Forms.TreeNode("TAS", 2, 2),
																																											   new System.Windows.Forms.TreeNode("FFP x2")})});
			this.tvOrders.Size = new System.Drawing.Size(140, 322);
			this.tvOrders.TabIndex = 1;
			this.tvOrders.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvOrders_AfterSelect);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// lblOrders
			// 
			this.lblOrders.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.lblOrders.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblOrders.Dock = System.Windows.Forms.DockStyle.Top;
			this.lblOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblOrders.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblOrders.Location = new System.Drawing.Point(0, 0);
			this.lblOrders.Name = "lblOrders";
			this.lblOrders.Size = new System.Drawing.Size(140, 20);
			this.lblOrders.TabIndex = 3;
			this.lblOrders.Text = "Orders";
			this.lblOrders.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox4
			// 
			this.groupBox4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox4.Controls.Add(this.pictureBox2);
			this.groupBox4.Location = new System.Drawing.Point(4, 44);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(40, 368);
			this.groupBox4.TabIndex = 67;
			this.groupBox4.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(32, 32);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox2.TabIndex = 0;
			this.pictureBox2.TabStop = false;
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Location = new System.Drawing.Point(612, 416);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 68;
			this.btnClose.Text = "&Close";
			this.btnClose.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlRecentOrders
			// 
			this.pnlRecentOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlRecentOrders.Controls.Add(this.patientDisplayPanel2);
			this.pnlRecentOrders.Controls.Add(this.grpOrders);
			this.pnlRecentOrders.Controls.Add(this.groupBox4);
			this.pnlRecentOrders.Controls.Add(this.btnClose);
			this.pnlRecentOrders.Location = new System.Drawing.Point(0, 32);
			this.pnlRecentOrders.Name = "pnlRecentOrders";
			this.pnlRecentOrders.Size = new System.Drawing.Size(692, 440);
			this.pnlRecentOrders.TabIndex = 70;
			// 
			// pnlPatientSelect
			// 
			this.pnlPatientSelect.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPatientSelect.Controls.Add(this.btnOK);
			this.pnlPatientSelect.Controls.Add(this.patientSelectTool1);
			this.pnlPatientSelect.Controls.Add(this.btnCancel);
			this.pnlPatientSelect.Location = new System.Drawing.Point(0, 32);
			this.pnlPatientSelect.Name = "pnlPatientSelect";
			this.pnlPatientSelect.Size = new System.Drawing.Size(692, 440);
			this.pnlPatientSelect.TabIndex = 76;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(532, 416);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 11;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// patientSelectTool1
			// 
			this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSelectTool1.DisplaySIAndTRs = true;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledMedicationButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledSIAndTRButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSelectTool1.Location = new System.Drawing.Point(4, 0);
			this.patientSelectTool1.Name = "patientSelectTool1";
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Size = new System.Drawing.Size(684, 412);
			this.patientSelectTool1.TabIndex = 10;
			this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
			this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(612, 416);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 12;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgRecentOrders
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 473);
			this.Controls.Add(this.pnlPatientSelect);
			this.Controls.Add(this.pnlRecentOrders);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.hlphelpChm.SetHelpString(this, "Recent_Orders.htm");
			this.MinimumSize = new System.Drawing.Size(700, 500);
			this.Name = "DlgRecentOrders";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Recent Orders";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgRecentOrders_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlRecentOrders, 0);
			this.Controls.SetChildIndex(this.pnlPatientSelect, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpOrders.ResumeLayout(false);
			this.pnlSelectedOrder.ResumeLayout(false);
			this.pnlRight.ResumeLayout(false);
			this.pnlBotRight.ResumeLayout(false);
			this.pnlDiagnosticTest.ResumeLayout(false);
			this.pnlComponents.ResumeLayout(false);
			this.pnlOrder.ResumeLayout(false);
			this.pnlLevel1.ResumeLayout(false);
			this.pnlTree.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.pnlRecentOrders.ResumeLayout(false);
			this.pnlPatientSelect.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				this.patientDisplayPanel2.Patient = value;
				//
				this.patientSelectTool1.EnabledRecentOrdersButton = false;
				this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ",string.Empty);
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.SetThisToolTip(btnClose,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC065.DlgRecentOrders());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.tvOrders.PathSeparator = "\t";
			//
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.pnlPatientSelect.Visible = true;
			this.pnlRecentOrders.Visible = false;
			//
			this.Patient = null;
			//
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
		}

		private void GetRecentOrders()
		{
			using (new WaitCursor())
			{
				if (this._patient != null)
				{
					DataSet dsComponents = BOL.OrderedComponent.GetRecentComponentOrders(this._patient.PatientGuid);
					_componentOrders = dsComponents.Tables[0];
					_units = dsComponents.Tables[1];
					//
                    DataSet dsTests = BOL.OrderedTest.GetRecentTestOrders(this._patient.PatientGuid);
					_diagnosticTests = dsTests.Tables[0];
					_testResults = dsTests.Tables[1];
				}
				else
				{
					_componentOrders = null;
					_units = null;
					_diagnosticTests = null;
					_testResults = null;
				}
			}
		}

		private void LoadRecentOrders()
		{
			this.tvOrders.Nodes.Clear();
			//
			foreach(DataRow drTestOrder in _diagnosticTests.Rows)
			{
				TreeNode node = new TreeNode();
				//
				bool found = false;
				foreach(TreeNode existingNode in this.tvOrders.Nodes)
				{
					DataRow drExistingOrder = (DataRow)existingNode.Tag;
					if ((Guid)drExistingOrder[TABLE.PatientOrder.PatientOrderGuid] == (Guid)drTestOrder[TABLE.PatientOrder.PatientOrderGuid])
					{
						node = existingNode;
						found = true;
						break;
					}
				}
				if (!found)
				{
					node = new TreeNode(Common.VBECSDateTime.FormatDateTimeString(drTestOrder[TABLE.PatientOrder.OrderReceivedDatetime]),1,1);
					node.Tag = drTestOrder;
					this.tvOrders.Nodes.Add(node);
				}
				//
				TreeNode subNode = new TreeNode(drTestOrder[TABLE.OrderableTest.OrderableTestText].ToString(),18,18);
				subNode.Tag = drTestOrder;
				node.Nodes.Add(subNode);
			
			}
			//
			foreach(DataRow drComponentOrder in _componentOrders.Rows)
			{
				TreeNode node = new TreeNode();
				//
				bool found = false;
				foreach(TreeNode existingNode in this.tvOrders.Nodes)
				{
					DataRow drExistingOrder = (DataRow)existingNode.Tag;
					if ((Guid)drExistingOrder[TABLE.PatientOrder.PatientOrderGuid] == (Guid)drComponentOrder[TABLE.PatientOrder.PatientOrderGuid])
					{
						node = existingNode;
						found = true;
						break;
					}
				}
				if (!found)
				{
					node = new TreeNode(Common.VBECSDateTime.FormatDateTimeString(drComponentOrder[TABLE.PatientOrder.OrderReceivedDatetime]),1,1);
					node.Tag = drComponentOrder;
					this.tvOrders.Nodes.Add(node);
				}
				//
				TreeNode subNode = new TreeNode(drComponentOrder[TABLE.ComponentClass.ComponentClassShortName].ToString()+" x "+drComponentOrder[TABLE.OrderedComponent.RequiredUnitQuantity].ToString(),17,17);
				subNode.Tag = drComponentOrder;
				node.Nodes.Add(subNode);
			}
			//
			this.tvOrders.Sorted = true;
		}

		private int GetSelectedLevel(TreeNode e)
		{
			if (this.tvOrders.Nodes.Count==0)
			{
				return -1;
			}
			string str = e.FullPath;
			string strcmp = this.tvOrders.PathSeparator;
			int pos = 0;
			int level = 0;
			while (str.IndexOf(strcmp,pos) > -1)
			{
				pos = str.IndexOf(strcmp,pos)+1;
				level = level +1;
			}
			return level;
		}

		private void LoadOrderDetails(DataRow drOrderDetails)
		{
			this.txtDateReceived.Text = Common.VBECSDateTime.FormatDateTimeString(drOrderDetails[TABLE.PatientOrder.OrderReceivedDatetime]);
			this.txtDivision.Text = drOrderDetails[TABLE.VamcDivision.DivisionName].ToString();
			this.txtSpecimenUID.Text = string.Empty;
			this.txtOrderStatus.Text = string.Empty;
		}

		private void LoadUnits(Guid orderedComponentGuid)
		{
			this.pnlComponents.Visible = true;
			this.pnlDiagnosticTest.Visible = false;
			this.lvComponents.Items.Clear();
			//
			DataRow[] drUnits = this._units.Select(TABLE.OrderedComponent.OrderedComponentGuid+" = '"+orderedComponentGuid.ToString()+"'");
			//
			if (drUnits == null)
				return;
			//
			foreach(DataRow drUnit in drUnits)
			{
				ListViewItem lvi = new ListViewItem();
				BOL.BloodUnit unit = new BOL.BloodUnit(drUnit);
				lvi.Text = unit.EyeReadableUnitId;
				lvi.SubItems.Add(unit.ProductShortName+", "+unit.FullProductCode);
				lvi.SubItems.Add(unit.BloodUnitMedia.AboRh.AboRHText);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(unit.BloodUnitMedia.UnitExpirationDate));
				lvi.SubItems.Add(unit.DonationType.DonationTypeText);
				lvi.SubItems.Add(unit.BloodUnitStatus.UnitStatusText);
				lvi.SubItems.Add(drUnit[TABLE.IssuedUnit.IssueToLocationName].ToString());
				this.lvComponents.Items.Add(lvi);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvComponents);
		}

		private void LoadTestResults(Guid orderedTestGuid)
		{
			this.pnlDiagnosticTest.Visible = true;
			this.pnlComponents.Visible = false;
			this.lvDiagnosticTest.Items.Clear();
			//
			DataRow[] drTests = this._testResults.Select(TABLE.OrderedTest.OrderedTestGuid+" = '"+orderedTestGuid.ToString()+"'");
			//
			if (drTests==null)
				return;
			//
			foreach(DataRow drTest in drTests)
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Text = drTest[TABLE.OrderableTest.OrderableTestText].ToString();
				lvi.SubItems.Add(drTest[ARTIFICIAL.Interp].ToString());
				lvi.SubItems.Add(drTest[TABLE.SpecimenTest.TestComments].ToString());
				this.lvDiagnosticTest.Items.Add(lvi);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvDiagnosticTest);
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.Patient = null;
			//
			this._componentOrders = null;
			this._diagnosticTests = null;
			this._testResults = null;
			this._units = null;
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.Patient = this.patientSelectTool1.SelectedPatient;
			this.GetRecentOrders();
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
            //CR 3554
			if (_diagnosticTests != null && (((_diagnosticTests == null) && (_componentOrders == null)) || ((_diagnosticTests.Rows.Count==0) && (_componentOrders.Rows.Count==0))))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC065.NoRecentOrders());
				return;
			}
			this.pnlPatientSelect.Visible = false;
			this.pnlRecentOrders.Visible = true;
			//
			this.LoadRecentOrders();

		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvDiagnosticTest_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void lvComponents_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 3)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
			}

		}

		private void tvOrders_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			using (new WaitCursor())
			{
				int level = GetSelectedLevel(this.tvOrders.SelectedNode);

				DataRow drOrder = (level == 1) ? (DataRow)this.tvOrders.SelectedNode.Parent.Tag : (DataRow)this.tvOrders.SelectedNode.Tag;
				//
				LoadOrderDetails(drOrder);
				//
				if (level == 1)		//level 1 = child
				{
					DataRow drChildOrder = (DataRow)this.tvOrders.SelectedNode.Tag;
					this.pnlLevel1.Visible = true;
					this.txtSpecimenUID.Text = drChildOrder[TABLE.PatientSpecimen.SpecimenUid].ToString();

					if (drChildOrder.Table.Columns.Contains(TABLE.ComponentClass.ComponentClassName))
					{
						//Component Orders do not have a reliable Task Status Code...
						string taskStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(BOL.OrderedComponent.GetStatus((Guid)drChildOrder[TABLE.OrderedComponent.OrderedComponentGuid])).ToString();
						System.Data.DataRow drTS = BOL.ReferenceData.GetTaskStatus(taskStatusCode);
						this.txtOrderStatus.Text = drTS[TABLE.TaskStatus.TaskStatusText].ToString();
						//
						LoadUnits((Guid)drChildOrder[TABLE.OrderedComponent.OrderedComponentGuid]);
					}
					else
					{
						//XM tests will appear as ordered tests, but are actually part of ordered component
						//and should display the associated component order status
						int orderableTestId = Convert.ToInt32(drChildOrder[TABLE.OrderedTest.OrderableTestId]);
						if (orderableTestId == (int)Common.OrderableTest.XM)
						{
							string taskStatusCode = Common.Utility.GetTaskStatusCodeFromEnum(BOL.OrderedComponent.GetStatus((Guid)drChildOrder[TABLE.OrderedTest.OrderedTestGuid])).ToString();
							System.Data.DataRow drTS = BOL.ReferenceData.GetTaskStatus(taskStatusCode);
							this.txtOrderStatus.Text = drTS[TABLE.TaskStatus.TaskStatusText].ToString();
						}
						else
						{
							this.txtOrderStatus.Text = drChildOrder[TABLE.TaskStatus.TaskStatusText].ToString();
						}
						//
						LoadTestResults((Guid)drChildOrder[TABLE.OrderedTest.OrderedTestGuid]);
					}
				}
				else			// level 0 = parent
				{

					this.pnlLevel1.Visible = false;
					this.pnlDiagnosticTest.Visible = false;
					this.pnlComponents.Visible = false;
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgRecentOrders_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (this.pnlPatientSelect.Visible && !this.btnOK.EnabledButton)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			if(this.patientDisplayPanel2.Visible)
			{
				textToSpeak = this.patientDisplayPanel2.GetErrorMessagesFor508();
			}
			if(this.patientSelectTool1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientSelectTool1.GetErrorMessagesFor508());
			}
			
			//
			this.SpeakMessage( textToSpeak );
		}
	}
}

